/*! For license information please see editor-interactions.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-interactions/src/components/controls/direction.tsx":function(e,t,n){n.r(t),n.d(t,{Direction:function(){return Direction}});var r=n("react"),o=n("@elementor/editor-controls"),i=n("@elementor/icons"),a=n("@wordpress/i18n");function Direction({value:e,onChange:t,interactionType:n}){const c=(0,r.useMemo)(()=>{const e="in"===n;return[{value:"top",label:e?(0,a.__)("From top","elementor"):(0,a.__)("To top","elementor"),renderContent:({size:t})=>e?r.createElement(i.ArrowDownSmallIcon,{fontSize:t}):r.createElement(i.ArrowUpSmallIcon,{fontSize:t}),showTooltip:!0},{value:"bottom",label:"in"===n?(0,a.__)("From bottom","elementor"):(0,a.__)("To bottom","elementor"),renderContent:({size:t})=>e?r.createElement(i.ArrowUpSmallIcon,{fontSize:t}):r.createElement(i.ArrowDownSmallIcon,{fontSize:t}),showTooltip:!0},{value:"left",label:"in"===n?(0,a.__)("From left","elementor"):(0,a.__)("To left","elementor"),renderContent:({size:t})=>e?r.createElement(i.ArrowRightIcon,{fontSize:t}):r.createElement(i.ArrowLeftIcon,{fontSize:t}),showTooltip:!0},{value:"right",label:"in"===n?(0,a.__)("From right","elementor"):(0,a.__)("To right","elementor"),renderContent:({size:t})=>e?r.createElement(i.ArrowLeftIcon,{fontSize:t}):r.createElement(i.ArrowRightIcon,{fontSize:t}),showTooltip:!0}]},[n]);return r.createElement(o.ToggleButtonGroupUi,{items:c,exclusive:!0,onChange:t,value:e})}},"./packages/packages/core/editor-interactions/src/components/controls/effect-type.tsx":function(e,t,n){n.r(t),n.d(t,{EffectType:function(){return EffectType}});var r=n("react"),o=n("@elementor/editor-controls"),i=n("@wordpress/i18n");function EffectType({value:e,onChange:t}){const n=[{value:"in",label:(0,i.__)("In","elementor"),renderContent:()=>(0,i.__)("In","elementor"),showTooltip:!0},{value:"out",label:(0,i.__)("Out","elementor"),renderContent:()=>(0,i.__)("Out","elementor"),showTooltip:!0}];return r.createElement(o.ToggleButtonGroupUi,{items:n,exclusive:!0,onChange:t,value:e})}},"./packages/packages/core/editor-interactions/src/components/controls/effect.tsx":function(e,t,n){n.r(t),n.d(t,{Effect:function(){return Effect}});var r=n("react"),o=n("@elementor/editor-ui"),i=n("@elementor/ui"),a=n("@wordpress/i18n");function Effect({value:e,onChange:t}){const n=[{key:"fade",label:(0,a.__)("Fade","elementor")},{key:"slide",label:(0,a.__)("Slide","elementor")},{key:"scale",label:(0,a.__)("Scale","elementor")}];return r.createElement(i.Select,{fullWidth:!0,displayEmpty:!0,size:"tiny",value:e,onChange:e=>t(e.target.value)},n.map(e=>r.createElement(o.MenuListItem,{key:e.key,value:e.key},e.label)))}},"./packages/packages/core/editor-interactions/src/components/controls/time-frame-indicator.tsx":function(e,t,n){n.r(t),n.d(t,{TimeFrameIndicator:function(){return TimeFrameIndicator}});var r=n("react"),o=n("@elementor/editor-ui"),i=n("@elementor/ui"),a=n("@wordpress/i18n");function TimeFrameIndicator({value:e,onChange:t}){const n=["0","100","200","300","400","500","750","1000","1250","1500"].map(e=>({key:e,label:(0,a.__)("%s MS","elementor").replace("%s",e)}));return r.createElement(i.Select,{fullWidth:!0,displayEmpty:!0,size:"tiny",value:e,onChange:e=>t(e.target.value)},n.map(e=>r.createElement(o.MenuListItem,{key:e.key,value:e.key},e.label)))}},"./packages/packages/core/editor-interactions/src/components/controls/trigger.tsx":function(e,t,n){n.r(t),n.d(t,{Trigger:function(){return Trigger}});var r=n("react"),o=n("@elementor/editor-ui"),i=n("@elementor/ui"),a=n("@wordpress/i18n");function Trigger({value:e,onChange:t}){const n=Object.entries({load:(0,a.__)("Page load","elementor"),scrollIn:(0,a.__)("Scroll into view","elementor")}).map(([e,t])=>({key:e,label:t}));return r.createElement(i.Select,{fullWidth:!0,displayEmpty:!0,size:"tiny",onChange:e=>t(e.target.value),value:e},n.map(e=>r.createElement(o.MenuListItem,{key:e.key,value:e.key},e.label)))}},"./packages/packages/core/editor-interactions/src/components/empty-state.tsx":function(e,t,n){n.r(t),n.d(t,{EmptyState:function(){return EmptyState}});var r=n("react"),o=n("@elementor/icons"),i=n("@elementor/ui"),a=n("@wordpress/i18n");const EmptyState=({onCreateInteraction:e})=>r.createElement(i.Stack,{alignItems:"center",justifyContent:"center",height:"100%",color:"text.secondary",sx:{p:2.5,pt:8,pb:5.5},gap:1.5},r.createElement(o.SwipeIcon,{fontSize:"large"}),r.createElement(i.Typography,{align:"center",variant:"subtitle2"},(0,a.__)("Animate elements with Interactions","elementor")),r.createElement(i.Typography,{align:"center",variant:"caption",maxWidth:"170px"},(0,a.__)("Add entrance animations and effects triggered by user interactions such as page load or scroll.","elementor")),r.createElement(i.Button,{variant:"outlined",color:"secondary",size:"small",sx:{mt:1},onClick:e},(0,a.__)("Create an interaction","elementor")))},"./packages/packages/core/editor-interactions/src/components/interaction-details.tsx":function(e,t,n){n.r(t),n.d(t,{InteractionDetails:function(){return InteractionDetails}});var r=n("react"),o=n("@elementor/editor-controls"),i=n("@elementor/ui"),a=n("@wordpress/i18n"),c=n("./packages/packages/core/editor-interactions/src/interactions-controls-registry.ts"),s=n("./packages/packages/core/editor-interactions/src/utils/prop-value-utils.ts"),l=n("./packages/packages/core/editor-interactions/src/components/controls/direction.tsx"),u=n("./packages/packages/core/editor-interactions/src/components/controls/effect.tsx"),p=n("./packages/packages/core/editor-interactions/src/components/controls/effect-type.tsx"),m=n("./packages/packages/core/editor-interactions/src/components/controls/time-frame-indicator.tsx");const d="load",g="fade",f="in",_="",v=300,I=0,k=!1,y="viewport",E=15,b=85,C=["scrollIn","scrollOut"],InteractionDetails=({interaction:e,onChange:t,onPlayInteraction:n})=>{const w=(0,s.extractString)(e.trigger,d),T=(0,s.extractString)(e.animation.value.effect,g),x=(0,s.extractString)(e.animation.value.type,f),h=(0,s.extractString)(e.animation.value.direction,_),S=(0,s.extractNumber)(e.animation.value.timing_config.value.duration,v),P=(0,s.extractNumber)(e.animation.value.timing_config.value.delay,I),D=(0,s.extractBoolean)(e.animation.value.config?.value.replay,k),O=(0,s.extractString)(e.animation.value.config?.value.relativeTo,y),F=(0,s.extractNumber)(e.animation.value.config?.value.offsetTop,E),R=(0,s.extractNumber)(e.animation.value.config?.value.offsetBottom,b),A=C.includes(w),$="scrollOn"===w,B=(0,r.useMemo)(()=>(0,c.getInteractionsControl)("trigger")?.component??null,[]),M=(0,r.useMemo)(()=>A?(0,c.getInteractionsControl)("replay")?.component??null:null,[A]),z=(0,r.useMemo)(()=>$?(0,c.getInteractionsControl)("relativeTo")?.component??null:null,[$]),q=(0,r.useMemo)(()=>$?(0,c.getInteractionsControl)("offsetTop")?.component??null:null,[$]),N=(0,r.useMemo)(()=>$?(0,c.getInteractionsControl)("offsetBottom")?.component??null:null,[$]),updateInteraction=r=>{const o=(i="direction"in r,a=r.effect,c=r.direction,"slide"!==a||c?i?c:h:"top");var i,a,c;const l=void 0!==r.replay?r.replay:D,u={...e,interaction_id:e.interaction_id,trigger:(0,s.createString)(r.trigger??w),animation:(0,s.createAnimationPreset)({effect:r.effect??T,type:r.type??x,direction:o,duration:r.duration??S,delay:r.delay??P,replay:l,relativeTo:r.relativeTo??O,offsetTop:r.offsetTop??F,offsetBottom:r.offsetBottom??R})};t(u);const p=(0,s.extractString)(u.interaction_id);setTimeout(()=>{n(p)},0)};return r.createElement(o.PopoverContent,{p:1.5},r.createElement(i.Grid,{container:!0,spacing:1.5},B&&r.createElement(Field,{label:(0,a.__)("Trigger","elementor")},r.createElement(B,{value:w,onChange:e=>updateInteraction({trigger:e})})),M&&r.createElement(Field,{label:(0,a.__)("Replay","elementor")},r.createElement(M,{value:D,onChange:e=>updateInteraction({replay:e}),disabled:!0}))),r.createElement(i.Divider,null),r.createElement(i.Grid,{container:!0,spacing:1.5},r.createElement(Field,{label:(0,a.__)("Effect","elementor")},r.createElement(u.Effect,{value:T,onChange:e=>updateInteraction({effect:e})})),r.createElement(Field,{label:(0,a.__)("Type","elementor")},r.createElement(p.EffectType,{value:x,onChange:e=>updateInteraction({type:e})})),r.createElement(Field,{label:(0,a.__)("Direction","elementor")},r.createElement(l.Direction,{value:h,onChange:e=>updateInteraction({direction:e}),interactionType:x})),r.createElement(Field,{label:(0,a.__)("Duration","elementor")},r.createElement(m.TimeFrameIndicator,{value:String(S),onChange:e=>updateInteraction({duration:parseInt(e,10)})})),r.createElement(Field,{label:(0,a.__)("Delay","elementor")},r.createElement(m.TimeFrameIndicator,{value:String(P),onChange:e=>updateInteraction({delay:parseInt(e,10)})}))),$&&z&&r.createElement(r.Fragment,null,r.createElement(i.Divider,null),r.createElement(i.Grid,{container:!0,spacing:1.5},r.createElement(Field,{label:(0,a.__)("Relative To","elementor")},r.createElement(z,{value:O,onChange:e=>updateInteraction({relativeTo:e})})),q&&r.createElement(Field,{label:(0,a.__)("Offset Top","elementor")},r.createElement(q,{value:String(F),onChange:e=>updateInteraction({offsetTop:parseInt(e,10)})})),N&&r.createElement(Field,{label:(0,a.__)("Offset Bottom","elementor")},r.createElement(N,{value:String(R),onChange:e=>updateInteraction({offsetBottom:parseInt(e,10)})}))),r.createElement(i.Divider,null)))};function Field({label:e,children:t}){return r.createElement(i.Grid,{item:!0,xs:12},r.createElement(o.PopoverGridContainer,null,r.createElement(i.Grid,{item:!0,xs:6},r.createElement(o.ControlFormLabel,null,e)),r.createElement(i.Grid,{item:!0,xs:6},t)))}},"./packages/packages/core/editor-interactions/src/components/interactions-list.tsx":function(e,t,n){n.r(t),n.d(t,{InteractionsList:function(){return InteractionsList},MAX_NUMBER_OF_INTERACTIONS:function(){return u}});var r=n("react"),o=n("@elementor/editor-controls"),i=n("@elementor/icons"),a=n("@elementor/ui"),c=n("@wordpress/i18n"),s=n("./packages/packages/core/editor-interactions/src/utils/prop-value-utils.ts"),l=n("./packages/packages/core/editor-interactions/src/components/interaction-details.tsx");const u=5;function InteractionsList(e){const{interactions:t,onSelectInteractions:n,onPlayInteraction:p,triggerCreateOnShowEmpty:m}=e,d=(0,r.useRef)(!1),g=(0,r.useCallback)(e=>{n(e)},[n]);(0,r.useEffect)(()=>{if(m&&!d.current&&(!t.items||0===t.items?.length)){d.current=!0;const e={version:1,items:[(0,s.createDefaultInteractionItem)()]};g(e)}},[m,t.items,g]);const f=(0,r.useMemo)(()=>t.items?.length>=u,[t.items?.length]),_=f?r.createElement(a.Alert,{color:"secondary",icon:r.createElement(i.InfoCircleFilledIcon,null),size:"small"},r.createElement(a.AlertTitle,null,(0,c.__)("Interactions","elementor")),r.createElement(a.Box,{component:"span"},(0,c.__)("You've reached the limit of 5 interactions for this element. Please remove an interaction before creating a new one.","elementor"))):void 0,v=(0,r.useCallback)(e=>{g({...t,items:e})},[t,g]),I=(0,r.useCallback)((e,n)=>{const r=structuredClone(t.items);r[e]={$$type:"interaction-item",value:n},g({...t,items:r})},[t,g]);return r.createElement(o.Repeater,{openOnAdd:!0,openItem:m?0:void 0,label:(0,c.__)("Interactions","elementor"),values:t.items,setValues:v,showDuplicate:!1,showToggle:!1,isSortable:!1,disableAddItemButton:f,addButtonInfotipContent:_,itemSettings:{initialValues:(0,s.createDefaultInteractionItem)(),Label:({value:e})=>(0,s.buildDisplayLabel)(e.value),Icon:()=>null,Content:({index:e,value:t})=>r.createElement(l.InteractionDetails,{key:e,interaction:t.value,onChange:t=>{I(e,t)},onPlayInteraction:p}),actions:e=>r.createElement(a.Tooltip,{key:"preview",placement:"top",title:(0,c.__)("Preview","elementor")},r.createElement(a.IconButton,{"aria-label":(0,c.__)("Play interaction","elementor"),size:"tiny",onClick:()=>p((0,s.extractString)(e.value.interaction_id))},r.createElement(i.PlayerPlayIcon,{fontSize:"tiny"})))}})}},"./packages/packages/core/editor-interactions/src/components/interactions-tab.tsx":function(e,t,n){n.r(t),n.d(t,{InteractionsTab:function(){return InteractionsTab}});var r=n("react"),o=n("@elementor/editor-elements"),i=n("@elementor/session"),a=n("@elementor/ui"),c=n("./packages/packages/core/editor-interactions/src/contexts/interactions-context.tsx"),s=n("./packages/packages/core/editor-interactions/src/contexts/popup-state-context.tsx"),l=n("./packages/packages/core/editor-interactions/src/components/empty-state.tsx"),u=n("./packages/packages/core/editor-interactions/src/components/interactions-list.tsx");const InteractionsTab=({elementId:e})=>r.createElement(s.PopupStateProvider,null,r.createElement(InteractionsTabContent,{elementId:e}));function InteractionsTabContent({elementId:e}){const t=(0,o.useElementInteractions)(e),n=(0,r.useState)(!1),a=t?.items?.length||n[0];return r.createElement(i.SessionStorageProvider,{prefix:e},a?r.createElement(c.InteractionsProvider,{elementId:e},r.createElement(InteractionsContent,{firstInteractionState:n})):r.createElement(l.EmptyState,{onCreateInteraction:()=>{n[1](!0)}}))}function InteractionsContent({firstInteractionState:e}){const{interactions:t,setInteractions:n,playInteractions:o}=(0,c.useInteractionsContext)(),i=(0,r.useCallback)(t=>{e[1](!1),n(t||void 0)},[n,e]);return r.createElement(a.Stack,{sx:{m:1,p:1.5},gap:2},r.createElement(u.InteractionsList,{triggerCreateOnShowEmpty:e[0],interactions:t,onSelectInteractions:i,onPlayInteraction:o}))}},"./packages/packages/core/editor-interactions/src/contexts/interactions-context.tsx":function(e,t,n){n.r(t),n.d(t,{InteractionsProvider:function(){return InteractionsProvider},useInteractionsContext:function(){return useInteractionsContext}});var r=n("react"),o=n("@elementor/editor-elements");const i=(0,r.createContext)(null),a={version:1,items:[]},InteractionsProvider=({children:e,elementId:t})=>{const n=(0,o.useElementInteractions)(t);(0,r.useEffect)(()=>{window.dispatchEvent(new CustomEvent("elementor/element/update_interactions"))},[]);const c={interactions:n??a,setInteractions:e=>{const n=e&&0===e.items?.length?void 0:e;(0,o.updateElementInteractions)({elementId:t,interactions:n})},playInteractions:e=>{(0,o.playElementInteractions)(t,e)}};return r.createElement(i.Provider,{value:c},e)},useInteractionsContext=()=>{const e=(0,r.useContext)(i);if(!e)throw new Error("useInteractionsContext must be used within InteractionsProvider");return e}},"./packages/packages/core/editor-interactions/src/contexts/popup-state-context.tsx":function(e,t,n){n.r(t),n.d(t,{PopupStateProvider:function(){return PopupStateProvider},usePopupStateContext:function(){return usePopupStateContext}});var r=n("react");const o=(0,r.createContext)(void 0),PopupStateProvider=({children:e})=>{const[t,n]=(0,r.useState)(!1),i=(0,r.useCallback)(()=>{n(!0)},[]),a=(0,r.useCallback)(()=>{n(!1)},[]);return r.createElement(o.Provider,{value:{openByDefault:t,triggerDefaultOpen:i,resetDefaultOpen:a}},e)},usePopupStateContext=()=>{const e=(0,r.useContext)(o);if(!e)throw new Error("usePopupStateContext must be used within PopupStateProvider");return e}},"./packages/packages/core/editor-interactions/src/hooks/on-duplicate.ts":function(e,t,n){n.r(t),n.d(t,{initCleanInteractionIdsOnDuplicate:function(){return initCleanInteractionIdsOnDuplicate}});var r=n("@elementor/editor-elements"),o=n("@elementor/editor-v1-adapters"),i=n("./packages/packages/core/editor-interactions/src/utils/prop-value-utils.ts"),a=n("./packages/packages/core/editor-interactions/src/utils/temp-id-utils.ts");function initCleanInteractionIdsOnDuplicate(){(0,o.registerDataHook)("after","document/elements/duplicate",(e,t)=>{(Array.isArray(t)?t:[t]).forEach(e=>{!function cleanInteractionIdsRecursive(e){const t=(0,r.getContainer)(e);if(!t)return;(0,r.getAllDescendants)(t).forEach(e=>{!function cleanInteractionIds(e){const t=(0,r.getContainer)(e);if(!t)return;const n=t.model.get("interactions");if(!n||!n.items)return;const o=structuredClone(n);o?.items?.forEach(e=>{"interaction-item"===e.$$type&&e.value&&(e.value.interaction_id=(0,i.createString)((0,a.generateTempInteractionId)()))}),t.model.set("interactions",o)}(e.id)})}(e.id)})})}},"./packages/packages/core/editor-interactions/src/init.ts":function(e,t,n){n.r(t),n.d(t,{init:function(){return init}});var r=n("./packages/packages/core/editor-interactions/src/components/controls/trigger.tsx"),o=n("./packages/packages/core/editor-interactions/src/hooks/on-duplicate.ts"),i=n("./packages/packages/core/editor-interactions/src/interactions-controls-registry.ts"),a=n("./packages/packages/core/editor-interactions/src/interactions-repository.ts"),c=n("./packages/packages/core/editor-interactions/src/providers/document-elements-interactions-provider.ts");function init(){try{a.interactionsRepository.register(c.documentElementsInteractionsProvider),(0,o.initCleanInteractionIdsOnDuplicate)(),(0,i.registerInteractionsControl)({type:"trigger",component:r.Trigger,options:["load","scrollIn"]})}catch(e){throw e}}},"./packages/packages/core/editor-interactions/src/interactions-controls-registry.ts":function(e,t,n){n.r(t),n.d(t,{getInteractionsControl:function(){return getInteractionsControl},getInteractionsControlOptions:function(){return getInteractionsControlOptions},registerInteractionsControl:function(){return registerInteractionsControl}});const r=new Map;function registerInteractionsControl({type:e,component:t,options:n}){r.set(e,{type:e,component:t,options:n})}function getInteractionsControl(e){return r.get(e)}function getInteractionsControlOptions(e){return r.get(e)?.options??[]}},"./packages/packages/core/editor-interactions/src/interactions-repository.ts":function(e,t,n){n.r(t),n.d(t,{interactionsRepository:function(){return r}});const r=(0,n("./packages/packages/core/editor-interactions/src/utils/create-interactions-repository.ts").createInteractionsRepository)()},"./packages/packages/core/editor-interactions/src/providers/document-elements-interactions-provider.ts":function(e,t,n){n.r(t),n.d(t,{ELEMENTS_INTERACTIONS_PROVIDER_KEY_PREFIX:function(){return a},documentElementsInteractionsProvider:function(){return c}});var r=n("@elementor/editor-elements"),o=n("@elementor/editor-v1-adapters"),i=n("./packages/packages/core/editor-interactions/src/utils/create-interactions-provider.ts");const a="document-elements-interactions-",c=(0,i.createInteractionsProvider)({key:()=>{const e=(0,r.getCurrentDocumentId)();if(!e){return`${a}pending`}return`${a}${e}`},priority:50,subscribe:e=>(0,o.__privateListenTo)([(0,o.windowEvent)("elementor/element/update_interactions")],()=>e()),actions:{all:()=>(0,r.getElements)().filter(e=>{const t=(0,r.getElementInteractions)(e.id);return!!t&&t?.items?.length>0}).map(e=>{const t=(0,r.getElementInteractions)(e.id);return{elementId:e.id,dataId:e.id,interactions:t||{version:1,items:[]}}})}})},"./packages/packages/core/editor-interactions/src/types.ts":function(e,t,n){n.r(t)},"./packages/packages/core/editor-interactions/src/utils/create-interactions-provider.ts":function(e,t,n){n.r(t),n.d(t,{createInteractionsProvider:function(){return createInteractionsProvider}});const r=10;function createInteractionsProvider({key:e,priority:t=r,subscribe:n=()=>()=>{},actions:o}){return{getKey:"string"==typeof e?()=>e:e,priority:t,subscribe:n,actions:{all:o.all}}}},"./packages/packages/core/editor-interactions/src/utils/create-interactions-repository.ts":function(e,t,n){n.r(t),n.d(t,{createInteractionsRepository:function(){return createInteractionsRepository}});const createInteractionsRepository=()=>{const e=[],getProviders=()=>e.slice(0).sort((e,t)=>e.priority>t.priority?-1:1);return{all:()=>getProviders().flatMap(e=>e.actions.all()),register:t=>{e.push(t)},subscribe:t=>{const n=e.map(e=>e.subscribe(t));return()=>{n.forEach(e=>e())}},getProviders:getProviders,getProviderByKey:t=>e.find(e=>{try{return e.getKey()===t}catch{return!1}})}}},"./packages/packages/core/editor-interactions/src/utils/get-interactions-config.ts":function(e,t,n){n.r(t),n.d(t,{getInteractionsConfig:function(){return getInteractionsConfig}});const r={constants:{defaultDuration:300,defaultDelay:0,slideDistance:100,scaleStart:.5,easing:"linear"},animationOptions:[]};function getInteractionsConfig(){return window.ElementorInteractionsConfig||r}},"./packages/packages/core/editor-interactions/src/utils/prop-value-utils.ts":function(e,t,n){n.r(t),n.d(t,{buildAnimationIdString:function(){return buildAnimationIdString},buildDisplayLabel:function(){return buildDisplayLabel},createAnimationPreset:function(){return createAnimationPreset},createBoolean:function(){return createBoolean},createConfig:function(){return createConfig},createDefaultInteractionItem:function(){return createDefaultInteractionItem},createDefaultInteractions:function(){return createDefaultInteractions},createInteractionItem:function(){return createInteractionItem},createNumber:function(){return createNumber},createString:function(){return createString},createTimingConfig:function(){return createTimingConfig},extractBoolean:function(){return extractBoolean},extractNumber:function(){return extractNumber},extractString:function(){return extractString}});var r=n("./packages/packages/core/editor-interactions/src/utils/temp-id-utils.ts");const createString=e=>({$$type:"string",value:e}),createNumber=e=>({$$type:"number",value:e}),createTimingConfig=(e,t)=>({$$type:"timing-config",value:{duration:createNumber(e),delay:createNumber(t)}}),createBoolean=e=>({$$type:"boolean",value:e}),createConfig=(e,t,n,r)=>({$$type:"config",value:{replay:createBoolean(e),relativeTo:createString(t??""),offsetTop:createNumber(n??0),offsetBottom:createNumber(r??100)}}),extractBoolean=(e,t=!1)=>e?.value??t,createAnimationPreset=({effect:e,type:t,direction:n,duration:r,delay:o,replay:i=!1,relativeTo:a,offsetTop:c,offsetBottom:s})=>({$$type:"animation-preset-props",value:{effect:createString(e),type:createString(t),direction:createString(n??""),timing_config:createTimingConfig(r,o),config:createConfig(i,a,c,s)}}),createInteractionItem=({trigger:e,effect:t,type:n,direction:r,duration:o,delay:i,interactionId:a,replay:c=!1,relativeTo:s,offsetTop:l,offsetBottom:u})=>({$$type:"interaction-item",value:{...a&&{interaction_id:createString(a)},trigger:createString(e),animation:createAnimationPreset({effect:t,type:n,direction:r,duration:o,delay:i,replay:c,relativeTo:s,offsetTop:l,offsetBottom:u})}}),createDefaultInteractionItem=()=>createInteractionItem({trigger:"load",effect:"fade",type:"in",duration:300,delay:0,replay:!1,interactionId:(0,r.generateTempInteractionId)()}),createDefaultInteractions=()=>({version:1,items:[createDefaultInteractionItem()]}),extractString=(e,t="")=>e?.value??t,extractNumber=(e,t=0)=>e?.value??t,buildAnimationIdString=e=>[extractString(e.trigger),extractString(e.animation.value.effect),extractString(e.animation.value.type),extractString(e.animation.value.direction),extractNumber(e.animation.value.timing_config.value.duration),extractNumber(e.animation.value.timing_config.value.delay)].join("-"),o={load:"On page load",scrollIn:"Scroll into view",scrollOut:"Scroll out of view",scrollOn:"While scrolling"},capitalize=e=>e.charAt(0).toUpperCase()+e.slice(1),buildDisplayLabel=e=>{const t=extractString(e.trigger),n=extractString(e.animation.value.effect),r=extractString(e.animation.value.type);return`${o[t]||capitalize(t)}: ${capitalize(n)} ${capitalize(r)}`}},"./packages/packages/core/editor-interactions/src/utils/temp-id-utils.ts":function(e,t,n){n.r(t),n.d(t,{generateTempInteractionId:function(){return generateTempInteractionId},isTempId:function(){return isTempId}});const r="temp-",o=/^temp-[a-z0-9]+$/i;function generateTempInteractionId(){return`${r}${Math.random().toString(36).substring(2,11)}`}function isTempId(e){return!!e&&o.test(e)}},"@elementor/editor-controls":function(e){e.exports=window.elementorV2.editorControls},"@elementor/editor-elements":function(e){e.exports=window.elementorV2.editorElements},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/session":function(e){e.exports=window.elementorV2.session},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(n){var r=t[n];if(void 0!==r)return r.exports;var o=t[n]={exports:{}};return e[n](o,o.exports,__webpack_require__),o.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n={};!function(){__webpack_require__.r(n),__webpack_require__.d(n,{ELEMENTS_INTERACTIONS_PROVIDER_KEY_PREFIX:function(){return a.ELEMENTS_INTERACTIONS_PROVIDER_KEY_PREFIX},EmptyState:function(){return e.EmptyState},InteractionsTab:function(){return t.InteractionsTab},createInteractionsProvider:function(){return i.createInteractionsProvider},getInteractionsConfig:function(){return r.getInteractionsConfig},init:function(){return c.init},interactionsRepository:function(){return o.interactionsRepository},registerInteractionsControl:function(){return s.registerInteractionsControl}});var e=__webpack_require__("./packages/packages/core/editor-interactions/src/components/empty-state.tsx"),t=__webpack_require__("./packages/packages/core/editor-interactions/src/components/interactions-tab.tsx"),r=(__webpack_require__("./packages/packages/core/editor-interactions/src/types.ts"),__webpack_require__("./packages/packages/core/editor-interactions/src/utils/get-interactions-config.ts")),o=__webpack_require__("./packages/packages/core/editor-interactions/src/interactions-repository.ts"),i=__webpack_require__("./packages/packages/core/editor-interactions/src/utils/create-interactions-provider.ts"),a=__webpack_require__("./packages/packages/core/editor-interactions/src/providers/document-elements-interactions-provider.ts"),c=__webpack_require__("./packages/packages/core/editor-interactions/src/init.ts"),s=__webpack_require__("./packages/packages/core/editor-interactions/src/interactions-controls-registry.ts")}(),(window.elementorV2=window.elementorV2||{}).editorInteractions=n}(),window.elementorV2.editorInteractions?.init?.();
//# sourceMappingURL=editor-interactions.js.map